<?php
require 'config.php';

// Check if user is logged in
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
$is_admin = isset($_SESSION['is_admin']) ? $_SESSION['is_admin'] : false;

$purchase_success = '';
$purchase_error = '';

// Handle purchase
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['buy']) && $user_id) {
    $project_id = (int)$_POST['project_id'];
    
    // Check if already purchased
    $check = $conn->query("SELECT * FROM orders WHERE user_id = $user_id AND project_id = $project_id");
    if ($check->num_rows > 0) {
        $purchase_error = "You already own this project!";
    } else {
        $project = $conn->query("SELECT * FROM projects WHERE id = $project_id")->fetch_assoc();
        if ($conn->query("INSERT INTO orders (user_id, project_id, amount, status) VALUES ($user_id, $project_id, {$project['price']}, 'SUCCESS')")) {
            $purchase_success = "Purchase successful! Check your dashboard for downloads.";
        } else {
            $purchase_error = "Error processing purchase. Please try again.";
        }
    }
}

// Get project details
$project_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$project = $conn->query("SELECT * FROM projects WHERE id = $project_id")->fetch_assoc();

if (!$project) {
    header('Location: projects.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($project['title']); ?> - SourceHub</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }
        
        header {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        nav {
            max-width: 1200px;
            margin: 0 auto;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .logo {
            font-size: 28px;
            font-weight: bold;
            color: #667eea;
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            gap: 20px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .nav-links a, .nav-links button {
            text-decoration: none;
            color: #333;
            padding: 8px 15px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
            background: none;
            font-size: 14px;
        }
        
        .nav-links a:hover {
            background: #f0f0f0;
        }
        
        .btn-logout {
            background: #e74c3c;
            color: white;
        }
        
        .btn-logout:hover {
            background: #c0392b;
        }
        
        .user-welcome {
            color: white;
            font-weight: bold;
            background: #667eea;
            padding: 8px 15px;
            border-radius: 5px;
        }
        
        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .project-detail {
            background: white;
            border-radius: 10px;
            padding: 40px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            margin-bottom: 40px;
        }
        
        .project-detail h1 {
            margin-bottom: 20px;
            color: #2c3e50;
            font-size: 36px;
        }
        
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border-left: 4px solid;
        }
        
        .alert-success {
            background: #d5f4e6;
            color: #27ae60;
            border-left-color: #27ae60;
        }
        
        .alert-error {
            background: #fadbd8;
            color: #c0392b;
            border-left-color: #c0392b;
        }
        
        .project-detail-description {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 5px;
            margin: 20px 0;
            line-height: 1.8;
            color: #555;
        }
        
        .project-detail-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin: 30px 0;
            padding: 20px 0;
            border-top: 1px solid #ecf0f1;
            border-bottom: 1px solid #ecf0f1;
            flex-wrap: wrap;
            gap: 20px;
        }
        
        .project-detail-footer h2 {
            color: #667eea;
            font-size: 32px;
            margin: 0;
        }
        
        .btn {
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            transition: all 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        .tech-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            margin: 20px 0;
        }
        
        .tech-tag {
            background: #ecf0f1;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 13px;
            color: #667eea;
            font-weight: 500;
        }
        
        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
            font-size: 14px;
        }
        
        .back-link:hover {
            text-decoration: underline;
        }
        
        footer {
            background: #2c3e50;
            color: white;
            text-align: center;
            padding: 20px;
            margin-top: 40px;
        }
        
        @media (max-width: 768px) {
            .project-detail {
                padding: 20px;
            }
            
            .project-detail h1 {
                font-size: 24px;
            }
            
            .project-detail-footer {
                flex-direction: column;
                justify-content: flex-start;
            }
            
            .btn {
                width: 100%;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <header>
        <nav>
            <a href="index.php" class="logo">🚀 SourceHub</a>
            <div class="nav-links">
                <a href="index.php">Home</a>
                <a href="projects.php">Projects</a>
                <?php if ($user_id): ?>
                    <a href="dashboard.php">Dashboard</a>
                    <?php if ($is_admin): ?>
                        <a href="admin.php" style="color: #f39c12; font-weight: bold;">🔒 Admin</a>
                    <?php endif; ?>
                    <span class="user-welcome">👤 <?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                    <button class="btn-logout" onclick="window.location.href='logout.php'">Logout</button>
                <?php else: ?>
                    <a href="login.php">Login</a>
                    <a href="register.php">Register</a>
                <?php endif; ?>
            </div>
        </nav>
    </header>

    <div class="container">
        <a href="projects.php" class="back-link">← Back to Projects</a>
        
        <div class="project-detail">
            <h1><?php echo htmlspecialchars($project['title']); ?></h1>
            
            <?php if ($purchase_success): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($purchase_success); ?></div>
            <?php endif; ?>
            
            <?php if ($purchase_error): ?>
                <div class="alert alert-error"><?php echo htmlspecialchars($purchase_error); ?></div>
            <?php endif; ?>
            
            <div class="project-detail-description">
                <?php echo nl2br(htmlspecialchars($project['long_description'])); ?>
            </div>
            
            <div class="project-detail-footer">
                <h2>$<?php echo number_format($project['price'], 2); ?></h2>
                <?php if ($user_id): ?>
                    <form method="POST" style="display: inline;">
                        <input type="hidden" name="project_id" value="<?php echo $project['id']; ?>">
                        <button type="submit" name="buy" class="btn">Buy Now</button>
                    </form>
                <?php else: ?>
                    <a href="login.php" class="btn">Login to Buy</a>
                <?php endif; ?>
            </div>
            
            <h3>Technologies Used:</h3>
            <div class="tech-tags">
                <?php 
                $techs = explode(',', $project['tech_stack']);
                foreach ($techs as $tech):
                ?>
                <span class="tech-tag"><?php echo htmlspecialchars(trim($tech)); ?></span>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <footer>
        <p>&copy; 2024 SourceHub - Digital Projects Marketplace. All rights reserved.</p>
    </footer>
</body>
</html>
